/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tools.ant.taskdefs.optional.dotnet;

import java.io.File;
import java.util.ArrayList;
import java.util.Iterator;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.DirectoryScanner;
import org.apache.tools.ant.Project;
import org.apache.tools.ant.taskdefs.optional.dotnet.NetCommand;
import org.apache.tools.ant.types.FileSet;

public class DotnetResource {
    private File file;
    private boolean embed = true;
    private Boolean isPublic = null;
    private String name = null;
    private ArrayList fileSets = new ArrayList();
    private String namespace = null;

    public boolean isEmbed() {
        return this.embed;
    }

    public void setEmbed(boolean embed) {
        this.embed = embed;
    }

    public File getFile() {
        return this.file;
    }

    public void setFile(File file) {
        this.file = file;
    }

    public Boolean getPublic() {
        return this.isPublic;
    }

    public void setPublic(Boolean aPublic) {
        this.isPublic = aPublic;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getNamespace() {
        return this.namespace;
    }

    public void setNamespace(String namespace) {
        this.namespace = namespace == null ? null : (namespace.length() == 0 || namespace.endsWith(".") ? namespace : namespace + '.');
    }

    private void checkParameters() {
        if (this.hasFilesets()) {
            if (this.getName() != null) {
                throw new BuildException("Cannot use <resource name=\"...\"> attribute with filesets");
            }
            if (this.getFile() != null) {
                throw new BuildException("Cannot use <resource file=\"...\"> attribute with filesets");
            }
        } else if (this.getNamespace() != null) {
            throw new BuildException("Cannot use <resource namespace=\"...\"> attribute without filesets");
        }
    }

    public void getParameters(Project p, NetCommand command, boolean csharpStyle) {
        this.checkParameters();
        if (this.hasFilesets()) {
            Iterator listIter = this.fileSets.iterator();
            while (listIter.hasNext()) {
                FileSet fs = (FileSet)listIter.next();
                String baseDirectory = fs.getDir(p).toString();
                String namespace = this.getNamespace();
                DirectoryScanner ds = fs.getDirectoryScanner(p);
                String[] files = ds.getIncludedFiles();
                for (int i = 0; i < files.length; ++i) {
                    String file = files[i];
                    command.addArgument(this.getParameter(baseDirectory + File.separatorChar + file, namespace == null ? null : namespace + file.replace(File.separatorChar, '.'), csharpStyle));
                }
            }
        } else {
            command.addArgument(this.getParameter(this.getFile().toString(), this.getName(), csharpStyle));
        }
    }

    private String getParameter(String fileName, String name, boolean csharpStyle) {
        StringBuffer buffer = new StringBuffer();
        buffer.append(this.isEmbed() ? "/resource" : "/linkresource");
        buffer.append(':');
        buffer.append(fileName);
        if (name != null) {
            buffer.append(',');
            buffer.append(name);
            if (csharpStyle) {
                if (this.getPublic() != null) {
                    throw new BuildException("This compiler does not support the public/private option.");
                }
                if (this.getPublic() != null) {
                    buffer.append(',');
                    buffer.append(this.getPublic() != false ? "public" : "private");
                }
            } else if (this.getPublic() != null) {
                throw new BuildException("You cannot have a public or private option without naming the resource");
            }
        }
        return buffer.toString();
    }

    public void addFileset(FileSet fileset) {
        this.fileSets.add(fileset);
    }

    public boolean hasFilesets() {
        return this.fileSets.size() > 0;
    }
}

