% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/capa.R
\name{capa.uv}
\alias{capa.uv}
\title{Detection of univariate anomalous segments and points using CAPA.}
\usage{
capa.uv(x, beta = NULL, beta_tilde = NULL, type = "meanvar",
  min_seg_len = 10, max_seg_len = Inf, transform = robustscale)
}
\arguments{
\item{x}{A numeric vector containing the data which is to be inspected.}

\item{beta}{A numeric constant indicating the penalty for adding an additional epidemic changepoint. It defaults to a BIC style penalty if no argument is provided.}

\item{beta_tilde}{A numeric constant indicating the penalty for adding an additional point anomaly. It defaults to a BIC style penalty if no argument is provided.}

\item{type}{A string indicating which type of deviations from the baseline are considered. Can be "meanvar" for collective anomalies characterised by joint changes in mean and
variance (the default) or "mean" for collective anomalies characterised by changes in mean only.}

\item{min_seg_len}{An integer indicating the minimum length of epidemic changes. It must be at least 2 and defaults to 10.}

\item{max_seg_len}{An integer indicating the maximum length of epidemic changes. It must be at least the min_seg_len and defaults to Inf.}

\item{transform}{A function used to transform the data prior to analysis by \code{\link{capa.uv}}. This can, for example, be used to compensate for the effects of autocorrelation
in the data. Importantly, the untransformed data remains available for post processing results obtained using \code{\link{capa.uv}}. The package includes several methods that are commonly used for
the transform, (see \code{\link{robustscale}} and \code{\link{ac_corrected}}), but a user defined function can be specified. The default values is \code{transform=robust_scale}.}
}
\value{
An S4 class of type capa.uv.class.
}
\description{
A technique for detecting anomalous segments and points in univariate time series data based on CAPA (Collective And Point Anomalies) by Fisch et al. (2018). CAPA assumes that the data has a certain mean and variance for most
time points and detects segments in which the mean and/or variance deviates from the typical mean and variance as collective anomalies. It also detects point
outliers and returns a measure of strength for the changes in mean and variance. If the number of anomalous windows scales linearly with the number of
data points, CAPA scales linearly with the number of data points. At
worst, if there are no anomalies at all and \code{max_seg_len} is unspecified, the computational cost of CAPA scales quadratically with the number of data points.
}
\examples{
library(anomaly)
data(machinetemp)
attach(machinetemp)
res<-capa.uv(temperature,type="mean")
canoms<-collective_anomalies(res)
dim(canoms)[1] # over fitted due to autocorrelation
psi<-0.98 # computed using covRob
inflated_penalty<-3*(1+psi)/(1-psi)*log(length(temperature))
res<-capa.uv(temperature,type="mean",beta=inflated_penalty,
             beta_tilde=inflated_penalty)
res

}
\references{
\insertRef{2018arXiv180601947F}{anomaly}
}
