% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/aes.r
\name{aes}
\alias{aes}
\title{Define aesthetic mappings.}
\usage{
aes(x, y, ...)
}
\arguments{
\item{x, y, ...}{List of name value pairs giving aesthetics to map to
variables. The names for x and y aesthetics can be omitted (because
they are so common); all other aesthetics must be named.}
}
\description{
Generate aesthetic mappings that describe how variables in the data are
mapped to visual properties (aesthetics) of geoms. This function also
standardise aesthetic names by performs partial name matching, converting
color to colour, and old style R names to ggplot names (eg. pch to shape,
cex to size)
}
\examples{
aes(x = mpg, y = wt)
aes(mpg, wt)

# You can also map aesthetics to functions of variables
aes(x = mpg ^ 2, y = wt / cyl)

# Aesthetic names are automatically standardised
aes(col = x)
aes(fg = x)
aes(color = x)
aes(colour = x)

# aes is almost always used with ggplot() or a layer
ggplot(mpg, aes(displ, hwy)) + geom_point()
ggplot(mpg) + geom_point(aes(displ, hwy))

# Aesthetics supplied to ggplot() are used as defaults for every layer
# you can override them, or supply different aesthetics for each layer
}
\seealso{
See \code{\link{aes_q}}/\code{\link{aes_string}} for standard
  evaluation versions of \code{aes}.

See
   \code{\link{aes_colour_fill_alpha}}, \code{\link{aes_group_order}},
   \code{\link{aes_linetype_size_shape}} and \code{\link{aes_position}}
   for more specific examples with different aesthetics.
}
