% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data_stream_permutations.R
\name{plot.list_permuted_networks}
\alias{plot.list_permuted_networks}
\title{Function to plot the network metrics distribution of permuted networks}
\usage{
\method{plot}{list_permuted_networks}(
  x,
  species_original_network,
  network_metrics = c("density", "mean_strength", "diameter", "transitivity"),
  ...
)
}
\arguments{
\item{x}{A list of igraph objects obtained obtained using the function obtain_permuted_network_versions}

\item{species_original_network}{An igraph object which is the original network}

\item{network_metrics}{A vector depicting names of global network metrics. This should be supplied as a character vector and the values 
should be chosen from "mean_strength", "density", "diameter", "transitivity". (default = c("mean_strength", "density", "diameter", "transitivity")).}

\item{...}{Further arguments are ignored.}
}
\value{
No return value, called for side effects.
}
\description{
Function to plot the network metrics distribution of permuted networks
}
\examples{
\donttest{
data(elk_data_2010, elk_network_2010)
permuted_versions <- obtain_permuted_network_versions(elk_data_2010, 
temporal_thresh = 7, spatial_thresh = 15, n_permutations = 10, n_cores = 2)
plot(permuted_versions, elk_network_2010)
}
}
