% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/run_anabel.R
\name{run_anabel}
\alias{run_anabel}
\title{Analysis for 1:1 Biomolecular Interactions}
\usage{
run_anabel(
  input = NA,
  samples_names_file = NULL,
  tstart = NA,
  tend = NA,
  tass = NA,
  tdiss = NA,
  conc = NA,
  drift = FALSE,
  decay = FALSE,
  quiet = TRUE,
  method = "SCA",
  outdir = NA,
  generate_output = "none",
  generate_Report = FALSE,
  generate_Plots = FALSE,
  generate_Tables = FALSE,
  save_tables_as = "xlsx",
  debug_mode = FALSE
)
}
\arguments{
\item{input}{Data.frame, an excel, or a csv file (full path) - required}

\item{samples_names_file}{An optional data.frame, an excel, or a csv file (full path) containing the samples names.
If provided, it must have two columns, Name and ID. ID: names of  columns in the input file; Name: sample's names.}

\item{tstart}{Numeric value of time's starting point (default: minimum time point in the input)}

\item{tend}{Numeric value of time's ending point (default: maximum time point in the input)}

\item{tass}{Numeric value of association time - required}

\item{tdiss}{Numeric value of dissociation time - required}

\item{conc}{Numeric value, the used concentration of the analyte; should be in molar (see \code{\link{convert_toMolar}}) - required}

\item{drift}{Boolean value, to apply drift correction (default: FALSE)}

\item{decay}{Boolean value, to apply surface decay correction (default: FALSE)}

\item{quiet}{Boolean value, to suppress notifications, messages and warnings (default: TRUE)}

\item{method}{a character string indicating which fitting method to be used. One of "SCA", "SCK", or "MCK", case insensitive (default: SCA).}

\item{outdir}{Path and name of the output directory in which the results will be saved (default: NA)}

\item{generate_output}{a character string indicating what kind of output will be generated. One of "none", "all", or "customized", case insensitive (default: none).
If "all" or "customized" were given, \code{outdir} is required.
If "customized" was given, at least one of \code{generate_Plots}, \code{generate_Tables}, or/and \code{generate_Report} must be set to TRUE}

\item{generate_Report}{Boolean value, should anabel generate a summary report of the experiment? (default: FALSE)}

\item{generate_Plots}{Boolean value, should anabel generate plots? (default: FALSE).
\code{generate_output} must be set to "customized"}

\item{generate_Tables}{Boolean value, should anabel generate tables? (default: FALSE)}

\item{save_tables_as}{a character string indicating data format to save the tables with; could be "xlsx", "csv", "txt" or "rds", case insensitive, (default: xlsx)}

\item{debug_mode}{Boolean value, anabel will return additional fitting details for each curve and the estimated response (default: FALSE)}
}
\value{
default returned value is a list of two data frames,
the kinetics table and the fit value of each time point (fit_raw).
If \code{dev_mode} was set to TRUE a third data frame will be returned containing the
initial value of the parameters and the fitting function.
}
\description{
Analysis for 1:1 biomolecular interactions, using one of single-curve analysis (SCA), single-cycle kinetics (SCK) or multi-cycle kinetics (MCK)
}
\examples{
\donttest{
# To analyse data using MCK method:
run_anabel(
  input = MCK_dataset, tstart = 1, tass = 21, tdiss = 140,
  conc = c(3.9E-9, 1.6E-8, 6.2E-8, 2.5E-7, 1.0e-6), method = "MCK"
)
}

}
\references{
Determination of rate and equilibrium binding constants for macromolecular
interactions by surface plasmon resonance.
D J O'Shannessy, M Brigham-Burke, K K Soneson, P Hensley, I Brooks
Analytical biochemistry \emph{212}, 457-468 (1993)

Analyzing a kinetic titration series using affinity biosensors.
Robert Karlsson, Phinikoula S Katsamba, Helena Nordin, Ewa Pol, David G Myszka
Analytical Biochemistry \emph{349}, 136–147 (2006)

Anabel: an online tool for the real-time kinetic analysis of binding events.
Stefan D Krämer, Johannes Wöhrle , Christin Rath, Günter Roth
Bioinformatics and Biology Insights \emph{13},  1-10 (2019)
}
\seealso{
\code{\link{convert_toMolar}}
}
