% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/development.R
\name{process_prism}
\alias{process_prism}
\title{Process PRISM data}
\usage{
process_prism(path = NULL, element = NULL, time = NULL, extent = NULL, ...)
}
\arguments{
\item{path}{character giving PRISM data path
Both file and directory path are acceptable.}

\item{element}{character(1). PRISM element name}

\item{time}{character(1). PRISM time name.
Should be character in length of 2, 4, 6, or 8.
"annual" is acceptable.}

\item{extent}{numeric(4) or SpatExtent giving the extent of the raster
if \code{NULL} (default), the entire raster is loaded}

\item{...}{Placeholders.}
}
\value{
a \code{SpatRaster} object with metadata of time and element.
}
\description{
This function imports and cleans raw PRISM data,
returning a single \code{SpatRaster} object.

Reads time series or 30-year normal PRISM data.
}
\examples{
## NOTE: Example is wrapped in `\dontrun{}` as function requires a large
##       amount of data which is not included in the package.
\dontrun{
prism <- process_prism(
  path = "./data/PRISM_ppt_stable_4kmM3_202104_nc.nc",
  element = "ppt",
  time = "202104"
)
}
}
\seealso{
\code{\link[terra:rast]{terra::rast}}, \code{\link[terra:metags]{terra::metags}}
}
\author{
Insang Song
}
\keyword{internal}
