% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/process_auxiliary.R
\name{process_locs_vector}
\alias{process_locs_vector}
\title{Process locations as \code{SpatVector}}
\usage{
process_locs_vector(locs, crs, radius)
}
\arguments{
\item{locs}{data.frame(1). Data frame containing columns for unique
identifier, latitude, and longitude. Latitude and longitude columns \strong{must}
be named "lat" and "lon", respectively.}

\item{crs}{Coordinate reference system (CRS) description utilizing
\code{terra::crs()}.}

\item{radius}{integer(1). Circular buffer size (meters).}
}
\value{
a \code{SpatVector} object
}
\description{
Detect \code{SpatVector} object, or convert locations from class \code{sf},
\code{data.frame} or \code{data.table} to
\code{SpatVector} object, project to coordinate reference system, and apply
circular buffer.
}
\keyword{auxiliary}
\keyword{internal}
