% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rbundle-set.R, R/rintersect.R, R/rsetdiff.R,
%   R/runion.R
\name{new-rbundle-set}
\alias{new-rbundle-set}
\alias{new_rintersect}
\alias{new_rsetdiff}
\alias{new_runion}
\title{Constructor for a set-based recurrence bundle}
\usage{
new_rintersect(
  rschedules = list(),
  rdates = new_date(),
  exdates = new_date(),
  ...,
  class = character()
)

new_rsetdiff(
  rschedules = list(),
  rdates = new_date(),
  exdates = new_date(),
  ...,
  class = character()
)

new_runion(
  rschedules = list(),
  rdates = new_date(),
  exdates = new_date(),
  ...,
  class = character()
)
}
\arguments{
\item{rschedules}{\verb{[list]}

A list of rschedules.}

\item{rdates}{\verb{[Date]}

A vector of dates to forcibly include in the event set.}

\item{exdates}{\verb{[Date]}

A vector of dates to forcibly exclude from the event set.}

\item{...}{\verb{[named dots]}

Additional named elements added to the rbundle object.}

\item{class}{\verb{[character]}

An optional subclass.}
}
\value{
A new rbundle subclass.
}
\description{
These constructors are developer focused tools that are not required for
normal usage of almanac. They construct new rbundle subclasses directly from
a list of existing rschedules.
\itemize{
\item \code{new_runion()} creates an runion.
\item \code{new_rintersect()} creates an rintersect.
\item \code{new_rsetdiff()} creates a rsetdiff.
}
}
\examples{
new_runion()

x <- daily()
y <- weekly()

rschedules <- list(x, y)

new_runion(rschedules)
}
