% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/github.R
\name{get_contributors}
\alias{get_contributors}
\title{get_contributors}
\usage{
get_contributors(
  org,
  repo,
  type = c("code", "issues", "discussion"),
  exclude_label = "wontfix",
  exclude_issues = NULL,
  alphabetical = FALSE,
  check_urls = TRUE,
  quiet = FALSE
)
}
\arguments{
\item{org}{Github organisation name for repository}

\item{repo}{Repository within \code{org} for which contributors are to be
extracted}

\item{type}{Type of contributions to include: 'code' for direct code
contributions (including documentation), 'issues' to recognise contributors
who open issues, and 'discussion' for contributing to discussions within
issues. Discussion contributions are only from individuals not present in
either 'issues' or 'code'; and 'issues' contributions are only from
individuals not present in 'code'.}

\item{exclude_label}{Exclude any contributions from issues with specified
label (default = "wontfix"; set to \code{NULL} or empty string to include all
issues).}

\item{exclude_issues}{Numbers of any issues (or pull requests) to be excluded
from lists of contributors.}

\item{alphabetical}{If \code{TRUE}, order contributors alphabetically, otherwise
order by decreasing numbers of contributions.}

\item{check_urls}{If \code{TRUE} (default), GitHub URLs of all contributors are
checked to ensure they are still valid. (This is generally the most
time-consuming stage, so set to 'FALSE' if you are sure all URLs are valid.)}

\item{quiet}{If \code{FALSE}, display progress information on screen.}
}
\description{
Get all contributors to a repository, including those who contribute to code,
open issues, and contribute to discussions in issues.
}
\examples{
\dontrun{
get_contributors (org = "ropenscilabs", repo = "allcontributors")
}
}
\seealso{
Other main: 
\code{\link{add_contributors}()}
}
\concept{main}
