% Generated by roxygen2 (4.0.1): do not edit by hand
\name{tab2vec}
\alias{tab2vec}
\title{Array to Vector conversion}
\usage{
tab2vec(tab)
}
\arguments{
\item{tab}{an array of counts}
}
\value{
a named integer vector.  the names correspond to the cell indices in the table.
}
\description{
Convert an array into a vector.
}
\details{
This function converts an array (or a multi-way contingency table) into a vector, using a consistent ordering of the cells.  The ordering of the cells is lexicographical and cannot be specified by the user.
}
\examples{
a <- array(1:24, c(2,3,4))
tab2vec(a)

data(Titanic)
tab2vec(Titanic)
Titanic[1,1,1,1]
Titanic[1,1,1,2]
}
\seealso{
\code{\link{vec2tab}}
}

