% Generated by roxygen2 (4.0.1): do not edit by hand
\name{count}
\alias{count}
\title{Count Integer Points in a Polytope}
\usage{
count(spec, dir = tempdir(), opts = "", quiet = TRUE, mpoly = TRUE)
}
\arguments{
\item{spec}{specification, see details and examples}

\item{dir}{directory to place the files in, without an ending /}

\item{opts}{options for count; "" for a hyperplane representation, "--vrep" for a vertex representation; see the LattE manual at \url{http://www.math.ucdavis.edu/~latte}}

\item{quiet}{show latte output}

\item{mpoly}{when opts = "--ehrhart-polynomial", return the mpoly version of it}
}
\value{
the count.  if the count is a number has less than 10 digits, an integer is returned.  if the number has 10 or more digits, an integer in a character string is returned. you may want to use the gmp package's as.bigz to parse it.
}
\description{
\code{count} uses LattE's count function to count the (integer) lattice points in a polytope and compute Ehrhart polynomials.
}
\details{
The specification should be one of the following: (1) a character string or strings containing an inequality in the mpoly expression format (see examples), (2) a list of vertices, or (3) raw code for LattE's count program.  If a character vector is supplied, (1) and (3) are distinguished by the number of strings.

Behind the scenes, count works by writing a latte file and running count on it.  If a specification other than a length one character is given to it (which is considered to be the code), count attempts to convert it into LattE code and then run count on it.
}
\examples{
\dontrun{





spec <- c("x + y <= 10", "x >= 1", "y >= 1")
count(spec)
count(spec, opts = "--dilation=10")
count(spec, opts = "--homog")

# by default, the output from LattE is in
list.files(tempdir())
list.files(tempdir(), recursive = TRUE)

# ehrhart polynomials
count(spec, opts = "--ehrhart-polynomial")
count(spec, opts = "--ehrhart-polynomial", mpoly = FALSE)


# the number of tables with the same marginals
data(politics)
count(c(
  "x11 + x12 == 10",
  "x21 + x22 == 10",
  "x11 + x21 == 9",
  "x12 + x22 == 11",
  "x11 >= 0", "x21 >= 0", "x12 >= 0", "x22 >= 0"
))
countTables(politics)


# by vertices
spec <- list(c(1,1),c(10,1),c(1,10),c(10,10))
count(spec)
count(spec, opts = "--vrep")

code <- "
5 3
1 -1 0
1 0 -1
1 -1 -1
0 1 0
0 0 1
"
count(code)



}
}

