% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sampeff.r
\name{sampeff}
\alias{sampeff}
\title{Visually assess change in sampling effort over time (author: Dietmar Straile)}
\usage{
sampeff(
  b_data,
  column,
  save.pdf = F,
  lakename = "",
  datecolumn = "date_dd_mm_yy",
  dateformat = "\%d-\%m-\%y"
)
}
\arguments{
\item{b_data}{Name of data.frame object}

\item{column}{column name or number for field containing abundance (biomass,biovol, etc.)
can be NA for presence absence}

\item{save.pdf}{TRUE/FALSE Should the output plot be saved to a file? defaults to FALSE}

\item{lakename}{Character string for labeling output plot}

\item{datecolumn}{Character String or number specifying dataframe field with date information}

\item{dateformat}{Character string specifying POSIX data format}
}
\value{
a time-series plot of minimum relative abundance over time. This should change 
        systematically with counting effort.
}
\description{
Visually assess change in sampling effort over time (author: Dietmar Straile)
}
\examples{
data(lakegeneva)
#example dataset with 50 rows

sampeff(lakegeneva,column=6) #column 6 contains biovolume
}
