% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_fairness.R
\name{CalFairness}
\alias{CalFairness}
\title{Calculate the principal fairness}
\usage{
CalFairness(apce, attr = c(2, 3))
}
\arguments{
\item{apce}{The list generated from \code{CalAPCE} or \code{CalAPCEparallel}.}

\item{attr}{The index of subgroups (within the output of CalAPCE/CalAPCEparallel) that corresponds to the protected attributes.}
}
\value{
A \code{data.frame} of the delta.
}
\description{
See Section 3.6 for more details.
}
\examples{
\donttest{
data(synth)
subgroup_synth = list(1:nrow(synth), which(synth$Sex==0), which(synth$Sex==1), 
                      which(synth$Sex==1&synth$White==0), which(synth$Sex==1&synth$White==1))
sample_mcmc = AiEvalmcmc(data = synth, n.mcmc = 10)
sample_apce = CalAPCE(data = synth, mcmc.re = sample_mcmc, subgroup = subgroup_synth, 
                      burnin = 0)
CalFairness(sample_apce)
}

}
