% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/aux_fct.R
\name{get_coder_metrics}
\alias{get_coder_metrics}
\title{Calculate reliability measures based on content analysis}
\usage{
get_coder_metrics(
  true_values = NULL,
  predicted_values = NULL,
  return_names_only = FALSE
)
}
\arguments{
\item{true_values}{\code{factor} containing the true labels/categories.}

\item{predicted_values}{\code{factor} containing the predicted labels/categories.}

\item{return_names_only}{\code{bool} If \code{TRUE} returns only the names
of the resulting vector. Use {FALSE} to request computation of the values.}
}
\value{
If \code{return_names_only=FALSE} returns a \code{vector} with the following reliability measures:
#'\itemize{
\item{\strong{iota_index: }}{Iota Index from the Iota Reliability Concept Version 2.}
\item{\strong{min_iota2: }}{Minimal Iota from Iota Reliability Concept Version 2.}
\item{\strong{avg_iota2: }}{Average Iota from Iota Reliability Concept Version 2.}
\item{\strong{max_iota2: }}{Maximum Iota from Iota Reliability Concept Version 2.}
\item{\strong{min_alpha: }}{Minmal Alpha Reliability from Iota Reliability Concept Version 2.}
\item{\strong{avg_alpha: }}{Average Alpha Reliability from Iota Reliability Concept Version 2.}
\item{\strong{max_alpha: }}{Maximum Alpha Reliability from Iota Reliability Concept Version 2.}
\item{\strong{static_iota_index: }}{Static Iota Index from Iota Reliability Concept Version 2.}
\item{\strong{dynamic_iota_index: }}{Dynamic Iota Index Iota Reliability Concept Version 2.}
\item{\strong{kalpha_nominal: }}{Krippendorff's Alpha for nominal variables.}
\item{\strong{kalpha_ordinal: }}{Krippendorff's Alpha for ordinal variables.}
\item{\strong{kendall: }}{Kendall's coefficient of concordance W.}
\item{\strong{kappa2_unweighted: }}{Cohen's Kappa with equal weights.}
\item{\strong{kappa2_equal_weighted: }}{Weighted Cohen's Kappa with equal weights.}
\item{\strong{kappa2_squared_weighted: }}{Weighted Cohen's Kappa with squared weights.}
\item{\strong{kappa_fleiss: }}{Fleiss' Kappa for multiple raters without exact estimation.}
\item{\strong{percentage_agreement: }}{Percentage Agreement.}
\item{\strong{gwet_ac: }}{Gwet's AC1/AC2 agreement coefficient.}
}

If \code{return_names_only=TRUE} returns only the names of the vector elements.
}
\description{
This function calculates different reliability measures which are based on the
empirical research method of content analysis.
}
\seealso{
Other Auxiliary Functions: 
\code{\link{array_to_matrix}()},
\code{\link{check_embedding_models}()},
\code{\link{create_iota2_mean_object}()},
\code{\link{create_synthetic_units}()},
\code{\link{generate_id}()},
\code{\link{get_folds}()},
\code{\link{get_n_chunks}()},
\code{\link{get_stratified_train_test_split}()},
\code{\link{get_synthetic_cases}()},
\code{\link{get_train_test_split}()},
\code{\link{matrix_to_array_c}()},
\code{\link{split_labeled_unlabeled}()},
\code{\link{summarize_tracked_sustainability}()}
}
\concept{Auxiliary Functions}
