% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cpv_ranges.R
\name{cpv_ranges}
\alias{cpv_ranges}
\title{Determine CPV ranges}
\usage{
cpv_ranges(alignment, exclude = c("-", "X", NA_character_))
}
\arguments{
\item{alignment}{A character matrix or an alignment object obtained with
\code{\link[=read_alignment]{read_alignment()}}. Rows are expected to be sequences of single characters
(protein residues), and columns the alignment positions. The first row must
be the reference sequence, i.e. the sequence whose substitutions will be
evaluated against.}

\item{exclude}{A vector of character values to be ignored when collecting the
amino acids at the position of interest.}
}
\value{
A \link[tibble:tibble-package]{tibble} with one single row, of six
variables, i.e., the minimum and maximum values for composition (\code{c_min}
and \code{c_max}), polarity (\code{p_min} and \code{p_max}) and molecular volume (\code{v_min}
and \code{v_max}).
}
\description{
This function determines the range (minimum and maximum) values for the three
amino acid side chain property values --- composition, polarity and molecular
volume --- from the amino acids at the alignment position of interest.

The alignment passed in \code{alignment} must be an already focused alignment of
three columns whose second column is the position of interest.
}
\examples{
# You need to first focus the alignment around the position of interest. The
# position of interest is position 4 in the example below. After subsetting
# the alignment, it becomes position 2.
alignment <- read_alignment('ATM')

alignment[, 3:5]

cpv_ranges(alignment[, 3:5])

# If at the position of interest there are symbols other than amino acid
# symbols, e.g. gaps ("-"), then these are ignored and the calculated ranges
# are based only on the observed amino acids.
alignment[, 270:272]

cpv_ranges(alignment[, 270:272])

}
\seealso{
\code{\link[=gv]{gv()}}
}
