% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/hi.R
\name{hi}
\alias{hi}
\title{Huglin Heliothermal Index (HI)}
\usage{
hi(mx, mn, dates, lati)
}
\arguments{
\item{mx}{vector of daily maximum temperature series.}

\item{mn}{vector of daily minimum temperature series.}

\item{dates}{vector of dates corresponding with daily temprature series}

\item{lati}{numeric value indicating the latitude of location.}
}
\value{
A numeric vector with annual values is returned.
}
\description{
Huglin Heliothermal Index (HI). Useful as a zoning tool (Huglin 1978).
}
\details{
Depending on the latitude, the function detects the hemisphere and considers growing season from 1st April to 30rd September (northern hemisphere) or from 1st October to 31st March (southern hemisphere).
}
\examples{

  hi(mx = daily_tmax,
    mn = daily_tmin,
    dates = seq.Date(as.Date('1981-01-01'),
            as.Date('2010-12-31'), by ='day'),
            lati = 42)

}
\references{
Huglin P. (1978) Nouveau mode d'evaluation des possibilities heliothermiques d'un milieu viticole. CR Acad Agr 64: 1117–1126
}
