% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/landsat8_thermal_single.R
\name{radiation_l8t}
\alias{radiation_l8t}
\title{Energy balance using Landsat-8 images (including thermal bands) with single agrometeorological data.}
\usage{
radiation_l8t(doy, RG, Ta, ET0, a, b)
}
\arguments{
\item{doy}{is the Day of Year (DOY)}

\item{RG}{is the global solar radiation}

\item{Ta}{is the average air temperature}

\item{ET0}{is the reference evapotranspiration}

\item{a}{is one of the regression coefficients of SAFER algorithm}

\item{b}{is one of the regression coefficients of SAFER algorithm}
}
\value{
It returns in raster format (.tif) the Surface Albedo at 24h scale ("Alb_24"), NDVI, Surface Temperature ("LST"), Crop Coefficient ("kc"), Actual Evapotranspiration (evapo), latent heat flux "LE_MJ"), net radiation ("Rn_MJ"), ground heat flux ("G_MJ") and the sensible heat flux ("H_MJ").
}
\description{
Energy balance using Landsat-8 images (including thermal bands) with single agrometeorological data.
}
