% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/binning.R
\name{executeBinning}
\alias{executeBinning}
\title{Binning the data to given bins.}
\usage{
executeBinning(x_vec, breaks = NULL, nbin.max = 100, method = "freq")
}
\arguments{
\item{x_vec}{The data to be binned.}

\item{breaks}{A numeric vector representing breaks of bins (If \code{NULL}, automatically generated).}

\item{nbin.max}{The maximum number of bins (used only if \code{breaks=NULL}).}

\item{method}{\code{"freq"} for equal frequency binning or \code{"width"} for equal width binning (used only if \code{breaks=NULL}).}
}
\value{
A list with the following fields:
\itemize{
\item \code{labels}: An integer vector with same length as \code{x_vec}, where \code{labels[i]==k} means the i-th element of \code{x_vec} is in the k-th bin.
\item \code{breaks}: Breaks of bins used for binning.
}
}
\description{
Binning the data to given bins.
}
\author{
Kenji Kondo
}
