% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/03-summary-statistics.R
\name{make_numeric_moment_function}
\alias{make_numeric_moment_function}
\alias{get_shift}
\title{Compute numeric moments}
\usage{
make_numeric_moment_function(nn, j, quad = NULL, centre = 0, shift = NULL, ...)

get_shift(gg)
}
\arguments{
\item{nn}{Order of moment to be computed, see \code{nn} argument of \code{compute_moment}.}

\item{j}{Numeric, positive integer, index of parameter vector to compute the numeric
moment for.}

\item{quad}{Optional, object of class \code{aghq}, only used if \code{shift} is not \code{NULL}.}

\item{centre}{Numeric scalar, added to \code{shift} to ensure that central moments
remain far from zero.}

\item{shift}{Numeric scalar, amount by which to shift \code{theta}. The function that this
outputs is \code{g(theta) = (theta)^nn + shift}, and \code{shift} is returned with the
object so that it may later be subtracted. Default of \code{NULL} chooses this value
internally.}

\item{...}{Not used.}

\item{gg}{Object of class \code{aghqmoment}. Returns the \code{shift} applied to
the moment function. Returns \code{0} if no shift applied.}
}
\value{
Object of class \code{aghqmoment}, see \code{make_moment_function}
}
\description{
Create a function suitable for computation of numeric moments. This function is
used internally by \code{compute_moment} when the user chooses \code{nn}, and is
unlikely to need to be called by a user directly.
}
