% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/04-aghq.R
\name{summary.aghq}
\alias{summary.aghq}
\title{Summary statistics computed using AGHQ}
\usage{
\method{summary}{aghq}(object, ...)
}
\arguments{
\item{object}{The return value from \code{aghq::aghq}.}

\item{...}{not used.}
}
\value{
A list of class \code{aghqsummary}, which has a print method. Elements:
\itemize{
\item{mode: }{the mode of the log posterior}
\item{hessian: }{the hessian of the log posterior at the mode}
\item{covariance: }{the inverse of the hessian of the log posterior at the mode}
\item{cholesky: }{the upper cholesky trinagle of the hessian of the log posterior at the mode}
\item{quadpoints: }{the number of quadrature points used in each dimension}
\item{dim: }{the dimension of the parameter space}
\item{summarytable: }{a table containing the mean, median, mode, standard deviation
and quantiles of each parameter, computed according to the posterior normalized
using AGHQ}
}
}
\description{
The \code{summary.aghq} method computes means, standard deviations, and
quantiles and the associated print method
prints these along with diagnostic and other information about
the quadrature.
}
\examples{

logfteta2d <- function(eta,y) {
  # eta is now (eta1,eta2)
  # y is now (y1,y2)
  n <- length(y)
  n1 <- ceiling(n/2)
  n2 <- floor(n/2)
  y1 <- y[1:n1]
  y2 <- y[(n1+1):(n1+n2)]
  eta1 <- eta[1]
  eta2 <- eta[2]
  sum(y1) * eta1 - (length(y1) + 1) * exp(eta1) - sum(lgamma(y1+1)) + eta1 +
    sum(y2) * eta2 - (length(y2) + 1) * exp(eta2) - sum(lgamma(y2+1)) + eta2
}
set.seed(84343124)
n1 <- 5
n2 <- 5
n <- n1+n2
y1 <- rpois(n1,5)
y2 <- rpois(n2,5)
objfunc2d <- function(x) logfteta2d(x,c(y1,y2))
funlist2d <- list(
  fn = objfunc2d,
  gr = function(x) numDeriv::grad(objfunc2d,x),
  he = function(x) numDeriv::hessian(objfunc2d,x)
)

thequadrature <- aghq(funlist2d,3,c(0,0))
# Summarize and automatically call its print() method when called interactively:
summary(thequadrature)
# or, compute the summary and save for further processing:
ss <- summary(thequadrature)
str(ss)

}
\seealso{
Other quadrature: 
\code{\link{aghq}()},
\code{\link{get_log_normconst}()},
\code{\link{laplace_approximation}()},
\code{\link{marginal_laplace_tmb}()},
\code{\link{marginal_laplace}()},
\code{\link{normalize_logpost}()},
\code{\link{optimize_theta}()},
\code{\link{plot.aghq}()},
\code{\link{print.aghqsummary}()},
\code{\link{print.aghq}()},
\code{\link{print.laplacesummary}()},
\code{\link{print.laplace}()},
\code{\link{print.marginallaplacesummary}()},
\code{\link{summary.laplace}()},
\code{\link{summary.marginallaplace}()}
}
\concept{quadrature}
