% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rpart-functions.R
\name{get_leaves}
\alias{get_leaves}
\title{Number of Leaves}
\usage{
get_leaves(tree)
}
\arguments{
\item{tree}{An \code{\link[rpart]{rpart}} object.}
}
\value{
The number of leaves.
}
\description{
Extracts the number of leaves of an \code{\link[rpart]{rpart}} object.
}
\examples{
## Generate data.
set.seed(1986)

n <- 3000
k <- 3

X <- matrix(rnorm(n * k), ncol = k)
colnames(X) <- paste0("x", seq_len(k))

y <- exp(X[, 1]) + 2 * X[, 2] * X[, 2] > 0 + rnorm(n)

## Construct tree.
library(rpart)
tree <- rpart(y ~ ., data = data.frame(y, X))

## Extract number of leaves.
n_leaves <- get_leaves(tree)
n_leaves

}
\seealso{
\code{\link{subtree}} \code{\link{node_membership}} \code{\link{leaf_membership}}
}
\author{
Riccardo Di Francesco
}
