% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/to_time_series.R
\name{to_time_series}
\alias{to_time_series}
\title{Create a tibble-like \code{tsd} (time-series data) object from time series data and corresponding dates.}
\usage{
to_time_series(
  cases = NULL,
  incidence = NULL,
  population = NULL,
  incidence_denominator = if (is.null(population)) NA_real_ else 1e+05,
  time,
  time_interval = c("weeks", "days", "months")
)
}
\arguments{
\item{cases}{An integer vector containing the time series cases.}

\item{incidence}{A numeric vector containing the time series incidences.
With the given incidence_denominator.}

\item{population}{An integer vector containing the time series background population.}

\item{incidence_denominator}{An integer >= 1, specifying the observations per incidence-denominator.}

\item{time}{A date vector containing the corresponding dates.}

\item{time_interval}{A character vector specifying the time interval. Choose between 'days', 'weeks', or 'months'.}
}
\value{
A \code{tsd} object containing:
\itemize{
\item 'time': The time point for the corresponding data.
\item 'cases': The number of cases at the time point.
\item 'incidence': The incidence per \code{incidence_denominator} at the time point. (optional)
\item 'population': The background population for the cases at the time point. (optional)
}
}
\description{
This function takes \code{cases} and the corresponding date vector (\code{time}) and converts it into a \code{tsd} object, which is
a time series data structure that can be used for time series analysis. If incidence is added, it will be used as
observation in all future use of the \code{aedseo} package on the defined \code{tsd} object.

Options:
\itemize{
\item \code{incidence} can be calculated if also supplying \code{cases}, \code{population}, and \code{incidence_denominator}.
\item \code{cases} can be calculated if also supplying \code{incidence}, \code{population} and \code{incidence_denominator}.
\item If background population changes during the time series,
it is used to adjust the growth rate in \code{seasonal_onset()}.
}
}
\examples{
# Create a `tsd` object with only cases
tsd_cases <- to_time_series(
  cases = c(10, 15, 20, 18),
  time = seq(from = as.Date("2023-01-01"), by = "1 week", length.out = 4)
)

# Create a `tsd` object with incidence from cases, population and default incidence_denominator
tsd_calculate_incidence <- to_time_series(
  cases = c(100, 120, 130, 150),
  time = seq(from = as.Date("2023-01-01"), by = "1 week", length.out = 4),
  population = c(3000000, 3000000, 3000000, 3000000)
)

# Create a `tsd` object with cases from incidence, population and default incidence_denominator
tsd_calculate_cases <- to_time_series(
  incidence = c(5, 7.8, 8, 8.5),
  time = seq(from = as.Date("2023-01-01"), by = "1 week", length.out = 4),
  population = c(3000000, 3000000, 3000000, 3000000)
)

}
