% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Prior.R, R/ContinuousPrior.R,
%   R/PointMassPrior.R
\name{posterior}
\alias{posterior}
\alias{posterior,DataDistribution,ContinuousPrior,numeric-method}
\alias{posterior,DataDistribution,PointMassPrior,numeric-method}
\title{Compute posterior distribution}
\usage{
posterior(dist, prior, x1, n1, ...)

\S4method{posterior}{DataDistribution,ContinuousPrior,numeric}(dist, prior, x1, n1, ...)

\S4method{posterior}{DataDistribution,PointMassPrior,numeric}(dist, prior, x1, n1, ...)
}
\arguments{
\item{dist}{a univariate \code{\link[=DataDistribution-class]{distribution}} object}

\item{prior}{a \code{\link{Prior}} object}

\item{x1}{stage-one test statistic}

\item{n1}{stage-one sample size}

\item{...}{further optional arguments}
}
\value{
Object of class \code{\link{Prior}}
}
\description{
Return posterior distribution given observing stage-one outcome.
}
\examples{
tmp <- ContinuousPrior(function(x) dunif(x, .2, .4), c(.2, .4))
posterior(Normal(), tmp, 2, 20)

posterior(Normal(), PointMassPrior(0, 1), 2, 20)

}
