% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/constraints.R
\name{subject_to}
\alias{subject_to}
\alias{ConstraintCollection}
\alias{evaluate,ConstraintsCollection,TwoStageDesign-method}
\title{Create a collection of constraints}
\usage{
subject_to(...)

\S4method{evaluate}{ConstraintsCollection,TwoStageDesign}(s, design, optimization = FALSE, ...)
}
\arguments{
\item{...}{either constraint objects (for \code{subject_to} or optional arguments passed to \code{evaluate})}

\item{s}{object of class \code{ConstraintCollection}}

\item{design}{object}

\item{optimization}{logical, if \code{TRUE} uses a relaxation to real
parameters of the underlying design; used for smooth optimization.}
}
\value{
an object of class \code{ConstraintsCollection}
}
\description{
\code{subject_to(...)} can be used to generate an object of class
\code{ConstraintsCollection} from an arbitrary number of (un)conditional
constraints.
}
\examples{
# define type one error rate and power
toer  <- Power(Normal(), PointMassPrior(0.0, 1))
power <- Power(Normal(), PointMassPrior(0.4, 1))

# create constrain collection
subject_to(
  toer  <= 0.025,
  power >= 0.9
)

}
\seealso{
\code{subject_to} is intended to be used for constraint
  specification the constraints in \code{\link{minimize}}.
}
