% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/agraph.R
\name{agraph}
\alias{agraph}
\title{Create an admixture graph object.}
\usage{
agraph(leaves, inner_nodes, parent_edges,
  admixture_proportions = extract_admixture_proportion_parameters(parent_edges))
}
\arguments{
\item{leaves}{The names of the leaves in the admixture graph.}

\item{inner_nodes}{The name of the inner nodes in the admxture graph.}

\item{parent_edges}{The list of edges in the graph, created by 
\code{\link{parent_edges}}.}

\item{admixture_proportions}{The list of admixture proportions; created by 
\code{\link{admixture_proportions}}.}
}
\value{
An admixture graph object.
}
\description{
Create an admixture graph object, an acyclic directed graph.
}
\examples{
leaves <- c("A", "B", "C", "D")
inner_nodes <- c("ab", "b", "bc", "abc", "abcd")
edges <- parent_edges(c(edge("A", "ab"),
                        edge("B", "b"),
                        edge("C", "bc"),
                        edge("D", "abcd"),
                        edge("ab", "abc"),
                        edge("bc", "abc"),
                        edge("abc", "abcd"),
                        admixture_edge("b", "ab", "bc")))
admixtures <- admixture_proportions(c(admix_props("b", "ab", "bc", "x")))

graph <- agraph(leaves, inner_nodes, edges, admixtures)

}
\seealso{
\code{\link{edge}}

\code{\link{admixture_edge}}

\code{\link{admix_props}}

\code{\link{parent_edges}}

\code{\link{admixture_proportions}}

\code{\link{plot.agraph}}
}

