% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/propose.R
\name{add_a_leaf}
\alias{add_a_leaf}
\title{Adds a new leaf to a graph.}
\usage{
add_a_leaf(graph, leaf_name, outgroup = "")
}
\arguments{
\item{graph}{An admixture graph.}

\item{leaf_name}{A name for the new leaf.}

\item{outgroup}{An optional parameter for the preferred outgroup, which can be the new leaf.}
}
\value{
A list of graphs made by adding a new leaf to the input graph. The list has no
        duplicate elements.
}
\description{
Given an admixture graph, selects an edge and branches off a new edge ending at a new leaf.
}
\examples{
\donttest{
# Take a look at how much trees there are: 
leaves <- c("1", "2")
inner_nodes <- c("R")
edges <- parent_edges(c(edge("1", "R"), edge("2", "R")))
admixtures <- NULL
Lambda <- agraph(leaves, inner_nodes, edges, admixtures)
set <- list(Lambda)
for (i in seq(1, 6)) {
  new_set <- list()
  for (tree in set) {
    new_set <- c(new_set, add_a_leaf(tree, paste(i + 2)))
  }
  set <- new_set
  cat("There are ")
  cat(length(set))
  cat(" different trees with ")
  cat(i + 2)
  cat(" labeled leaves.")
  cat("\\n")
}
# In general, there are 1*3*5*...*(2n - 5) different trees with n labeled leaves
# (A001147 in the online encyclopedia of integer sequences).
# Exhaustive search through the graph space is hard!
}

}
\seealso{
\code{\link{make_permutations}}

\code{\link{four_leaves_graphs}}

\code{\link{five_leaves_graphs}}

\code{\link{six_leaves_graphs}}

\code{\link{seven_leaves_trees}}

\code{\link{eight_leaves_trees}}

\code{\link{fit_permutations_and_graphs}}

\code{\link{add_an_admixture}}

\code{\link{add_an_admixture2}}

\code{\link{make_an_outgroup}}
}

