% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/PatraSen_dist_calc.R
\name{PatraSen_dist_calc}
\alias{PatraSen_dist_calc}
\title{Compute the distance to be minimized using Patra and Sen estimation technique in admixture models}
\usage{
PatraSen_dist_calc(data, gridsize = 200)
}
\arguments{
\item{data}{Sample where the known component density of the admixture model has been transformed into a Uniform(0,1) distribution.}

\item{gridsize}{Gridsize to make the computations.}
}
\value{
a list containing the evaluated distance and some additional information.
}
\description{
Compute the distance to be minimized using Patra and Sen estimation technique by integrating along some given grid
the appropriate distance. For further developments, see 'Details' below.
}
\details{
See Patra, R.K. and Sen, B. (2016); Estimation of a Two-component Mixture Model with Applications to Multiple Testing;
JRSS Series B, 78, pp. 869--893.
}
\examples{
comp.dist <- list(f = 'norm', g = 'norm')
comp.param <- list(f = list(mean = 3, sd = 0.5), g = list(mean = 0, sd = 1))
data1 <- rsimmix(n = 3000, unknownComp_weight = 0.6, comp.dist, comp.param)[['mixt.data']]
data1_transfo <- knownComp_to_uniform(data = data1, comp.dist = list(comp.dist$f, comp.dist$g),
                                      comp.param = list(comp.param$f, comp.param$g))
PatraSen_dist_calc(data = data1_transfo, gridsize = 200)

}
\author{
Xavier Milhaud \href{mailto:xavier.milhaud.research@gmail.com}{xavier.milhaud.research@gmail.com}
}
