% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/derive_param_exist_flag.R
\name{derive_param_exist_flag}
\alias{derive_param_exist_flag}
\title{Add an Existence Flag Parameter}
\usage{
derive_param_exist_flag(
  dataset = NULL,
  dataset_ref,
  dataset_add,
  condition,
  true_value = "Y",
  false_value = NA_character_,
  missing_value = NA_character_,
  filter_add = NULL,
  by_vars = get_admiral_option("subject_keys"),
  set_values_to
)
}
\arguments{
\item{dataset}{Input dataset

The variables specified by the \code{by_vars} argument are expected to be in the dataset.
\code{PARAMCD} is expected as well.

\describe{
\item{Default value}{\code{NULL}}
}}

\item{dataset_ref}{Reference dataset, e.g., ADSL

The variables specified in \code{by_vars} are expected. For each group
(as defined by \code{by_vars}) from the specified dataset (\code{dataset_ref}),
the existence flag is calculated and added as a new observation to the
input datasets (\code{dataset}).

\describe{
\item{Default value}{none}
}}

\item{dataset_add}{Additional dataset

The variables specified by the \code{by_vars} parameter are expected.

This dataset is used to check if an event occurred or not. Any observation
in the dataset fulfilling the event condition (\code{condition}) is considered
as an event.

\describe{
\item{Default value}{none}
}}

\item{condition}{Event condition

The condition is evaluated at the additional dataset (\code{dataset_add}).

For all groups where it evaluates as \code{TRUE} at least once \code{AVALC} is set
to the true value (\code{true_value}) for the new observations.

For all groups where it evaluates as \code{FALSE} or \code{NA} for all observations
\code{AVALC} is set to the false value (\code{false_value}).

For all groups not present in the additional dataset \code{AVALC} is set to
the missing value (\code{missing_value}).

\describe{
\item{Default value}{none}
}}

\item{true_value}{True value

For all groups with at least one observations in the additional dataset
(\code{dataset_add}) fulfilling the event condition (\code{condition}), \code{AVALC} is
set to the specified value (\code{true_value}).

\describe{
\item{Permitted values}{A character scalar}
\item{Default value}{\code{"Y"}}
}}

\item{false_value}{False value

For all groups with at least one observations in the additional dataset
(\code{dataset_add}) but none of them is fulfilling the event condition
(\code{condition}), \code{AVALC} is set to the specified value (\code{false_value}).

\describe{
\item{Permitted values}{A character scalar}
\item{Default value}{\code{NA_character_}}
}}

\item{missing_value}{Values used for missing information

For all groups without an observation in the additional dataset
(\code{dataset_add}), \code{AVALC} is set to the specified value (\code{missing_value}).

\describe{
\item{Permitted values}{A character scalar}
\item{Default value}{\code{NA_character_}}
}}

\item{filter_add}{Filter for additional data

Only observations fulfilling the specified condition are taken into account
for flagging. If the parameter is not specified, all observations are
considered.

\describe{
\item{Permitted values}{a condition}
\item{Default value}{\code{NULL}}
}}

\item{by_vars}{Grouping variables

\describe{
\item{Default value}{\code{get_admiral_option("subject_keys")}}
}}

\item{set_values_to}{Variables to set

A named list returned by \code{exprs()} defining the variables to be set for the
new parameter, e.g. \code{exprs(PARAMCD = "MDIS", PARAM = "Measurable Disease at Baseline")} is expected. The values must be symbols, character strings,
numeric values, \code{NA}, or expressions.

\describe{
\item{Default value}{none}
}}
}
\value{
The input dataset with a new parameter indicating if an event
occurred (\code{AVALC} and the variables specified by \code{by_vars}
and \code{set_value_to} are populated for the new parameter).
}
\description{
Add a new parameter indicating that a certain event exists in a dataset.
\code{AVALC} and \code{AVAL} indicate if an event occurred or not. For example, the
function can derive a parameter indicating if there is measurable disease at
baseline.
}
\details{
\enumerate{
\item The additional dataset (\code{dataset_add}) is restricted to the observations
matching the \code{filter_add} condition.
\item For each group in \code{dataset_ref} a new observation is created.
\itemize{
\item The \code{AVALC} variable is added and set to the true value (\code{true_value})
if for the group at least one observation exists in the (restricted)
additional dataset where the condition evaluates to \code{TRUE}.
\item It is set to the false value (\code{false_value}) if for the group at least
one observation exists and for all observations the condition evaluates
to \code{FALSE} or \code{NA}.
\item Otherwise, it is set to the missing value (\code{missing_value}), i.e., for
those groups not in \code{dataset_add}.
}
\item The variables specified by the \code{set_values_to} parameter are added to
the new observations.
\item The new observations are added to input dataset.
}
}
\examples{
library(tibble)
library(dplyr, warn.conflicts = FALSE)
library(lubridate)

# Derive a new parameter for measurable disease at baseline
adsl <- tribble(
  ~USUBJID,
  "1",
  "2",
  "3"
) \%>\%
  mutate(STUDYID = "XX1234")

tu <- tribble(
  ~USUBJID, ~VISIT,      ~TUSTRESC,
  "1",      "SCREENING", "TARGET",
  "1",      "WEEK 1",    "TARGET",
  "1",      "WEEK 5",    "TARGET",
  "1",      "WEEK 9",    "NON-TARGET",
  "2",      "SCREENING", "NON-TARGET",
  "2",      "SCREENING", "NON-TARGET"
) \%>\%
  mutate(
    STUDYID = "XX1234",
    TUTESTCD = "TUMIDENT"
  )

derive_param_exist_flag(
  dataset_ref = adsl,
  dataset_add = tu,
  filter_add = TUTESTCD == "TUMIDENT" & VISIT == "SCREENING",
  condition = TUSTRESC == "TARGET",
  false_value = "N",
  missing_value = "N",
  set_values_to = exprs(
    AVAL = yn_to_numeric(AVALC),
    PARAMCD = "MDIS",
    PARAM = "Measurable Disease at Baseline"
  )
)
}
\seealso{
BDS-Findings Functions for adding Parameters/Records:
\code{\link{default_qtc_paramcd}()},
\code{\link{derive_expected_records}()},
\code{\link{derive_extreme_event}()},
\code{\link{derive_extreme_records}()},
\code{\link{derive_locf_records}()},
\code{\link{derive_param_bmi}()},
\code{\link{derive_param_bsa}()},
\code{\link{derive_param_computed}()},
\code{\link{derive_param_doseint}()},
\code{\link{derive_param_exposure}()},
\code{\link{derive_param_framingham}()},
\code{\link{derive_param_map}()},
\code{\link{derive_param_qtc}()},
\code{\link{derive_param_rr}()},
\code{\link{derive_param_wbc_abs}()},
\code{\link{derive_summary_records}()}
}
\concept{der_prm_bds_findings}
\keyword{der_prm_bds_findings}
