% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/derive_param_exist_flag.R
\name{derive_param_exist_flag}
\alias{derive_param_exist_flag}
\title{Add an Existence Flag Parameter}
\usage{
derive_param_exist_flag(
  dataset = NULL,
  dataset_adsl,
  dataset_add,
  condition,
  true_value = "Y",
  false_value = NA_character_,
  missing_value = NA_character_,
  filter_add = NULL,
  aval_fun = yn_to_numeric,
  subject_keys = vars(STUDYID, USUBJID),
  set_values_to
)
}
\arguments{
\item{dataset}{Input dataset

The variables specified for \code{subject_keys} and the \code{PARAMCD} variable are
expected.}

\item{dataset_adsl}{ADSL input dataset

The variables specified for \code{subject_keys} are expected. For each subject
(as defined by \code{subject_keys}) from the specified dataset (\code{dataset_adsl}),
the existence flag is calculated and added as a new observation to the
input datasets (\code{dataset})}

\item{dataset_add}{Additional dataset

The variables specified by the \code{subject_keys} parameter are expected.

This dataset is used to check if an event occurred or not. Any observation
in the dataset fulfilling the event condition (\code{condition}) is considered
as an event.}

\item{condition}{Event condition

The condition is evaluated at the additional dataset (\code{dataset_add}).

For all subjects where it evaluates as \code{TRUE} at least once \code{AVALC} is set
to the true value (\code{true_value}) for the new observations.

For all subjects where it evaluates as \code{FALSE} or \code{NA} for all observations
\code{AVALC} is set to the false value (\code{false_value}).

For all subjects not present in the additional dataset \code{AVALC} is set to
the missing value (\code{missing_value}).}

\item{true_value}{True value

For all subjects with at least one observations in the additional dataset
(\code{dataset_add}) fulfilling the event condition (\code{condition}), \code{AVALC} is
set to the specified value (\code{true_value}).

\emph{Default}: \code{"Y"}

\emph{Permitted Value}: A character scalar}

\item{false_value}{False value

For all subjects with at least one observations in the additional dataset
(\code{dataset_add}) but none of them is fulfilling the event condition
(\code{condition}), \code{AVALC} is set to the specified value (\code{false_value}).

\emph{Default}: \code{NA_character_}

\emph{Permitted Value}: A character scalar}

\item{missing_value}{Values used for missing information

For all subjects without an observation in the additional dataset
(\code{dataset_add}), \code{AVALC} is set to the specified value (\code{missing_value}).

\emph{Default}: \code{NA_character_}

\emph{Permitted Value}: A character scalar}

\item{filter_add}{Filter for additional data

Only observations fulfilling the specified condition are taken into account
for flagging. If the parameter is not specified, all observations are
considered.

\emph{Permitted Values}: a condition}

\item{aval_fun}{Function to map character analysis value (\code{AVALC}) to numeric
analysis value (\code{AVAL})

The (first) argument of the function must expect a character vector and the
function must return a numeric vector.

\emph{Default:} \code{yn_to_numeric} (see \code{yn_to_numeric()} for details)}

\item{subject_keys}{Variables to uniquely identify a subject

A list of symbols created using \code{vars()} is expected.}

\item{set_values_to}{Variables to set

A named list returned by \code{vars()} defining the variables to be set for the
new parameter, e.g. \code{vars(PARAMCD = "MDIS", PARAM = "Measurable Disease at Baseline")} is expected. The values must be symbols, character strings,
numeric values, or \code{NA}.}
}
\value{
The input dataset with a new parameter indicating if an event
occurred (\code{AVALC}, \code{AVAL}, and the variables specified by \code{subject_keys}
and \code{set_value_to} are populated for the new parameter)
}
\description{
Add a new parameter indicating that a certain event exists in a dataset.
\code{AVALC} and \code{AVAL} indicate if an event occurred or not. For example, the
function can derive a parameter indicating if there is measureable disease at
baseline.
}
\details{
\enumerate{
\item The additional dataset (\code{dataset_add}) is restricted to the observations
matching the \code{filter_add} condition.
\item For each subject in \code{dataset_adsl} a new observation is created.
\itemize{
\item The \code{AVALC} variable is added and set to the true value (\code{true_value})
if for the subject at least one observation exists in the (restricted)
additional dataset where the condition evaluates to \code{TRUE}.
\item It is set to the false value (\code{false_value}) if for the subject at least
one observation exists and for all observations the condition evaluates
to \code{FALSE} or \code{NA}.
\item Otherwise, it is set to the missing value (\code{missing_value}), i.e., for
those subject not in \code{dataset_add}.
}
\item The \code{AVAL} variable is added and set to \code{aval_fun(AVALC)}.
\item The variables specified by the \code{set_values_to} parameter are added to
the new observations.
\item The new observations are added to input dataset.
}
}
\examples{
library(dplyr)
library(lubridate)

# Derive a new parameter for measurable disease at baseline
adsl <- tibble::tribble(
  ~USUBJID,
  "1",
  "2",
  "3"
) \%>\%
  mutate(STUDYID = "XX1234")

tu <- tibble::tribble(
  ~USUBJID, ~VISIT,      ~TUSTRESC,
  "1",      "SCREENING", "TARGET",
  "1",      "WEEK 1",    "TARGET",
  "1",      "WEEK 5",    "TARGET",
  "1",      "WEEK 9",    "NON-TARGET",
  "2",      "SCREENING", "NON-TARGET",
  "2",      "SCREENING", "NON-TARGET"
) \%>\%
  mutate(
    STUDYID = "XX1234",
    TUTESTCD = "TUMIDENT"
  )

derive_param_exist_flag(
  dataset_adsl = adsl,
  dataset_add = tu,
  filter_add = TUTESTCD == "TUMIDENT" & VISIT == "SCREENING",
  condition = TUSTRESC == "TARGET",
  false_value = "N",
  missing_value = "N",
  set_values_to = vars(
    PARAMCD = "MDIS",
    PARAM = "Measurable Disease at Baseline"
  )
)
}
\seealso{
BDS-Findings Functions for adding Parameters/Records: 
\code{\link{default_qtc_paramcd}()},
\code{\link{derive_extreme_records}()},
\code{\link{derive_param_bmi}()},
\code{\link{derive_param_bsa}()},
\code{\link{derive_param_computed}()},
\code{\link{derive_param_doseint}()},
\code{\link{derive_param_exposure}()},
\code{\link{derive_param_first_event}()},
\code{\link{derive_param_framingham}()},
\code{\link{derive_param_map}()},
\code{\link{derive_param_qtc}()},
\code{\link{derive_param_rr}()},
\code{\link{derive_param_wbc_abs}()},
\code{\link{derive_summary_records}()}
}
\author{
Stefan Bundfuss
}
\concept{der_prm_bds_findings}
\keyword{der_prm_bds_findings}
