% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/assertions.R
\name{assert_logical_scalar}
\alias{assert_logical_scalar}
\title{Is an Argument a Logical Scalar (Boolean)?}
\usage{
assert_logical_scalar(arg)
}
\arguments{
\item{arg}{A function argument to be checked}
}
\value{
The function throws an error if \code{arg} is neither \code{TRUE} or \code{FALSE}. Otherwise,
the input is returned invisibly.
}
\description{
Checks if an argument is a logical scalar
}
\examples{
example_fun <- function(flag) {
  assert_logical_scalar(flag)
}

example_fun(FALSE)

try(example_fun(NA))

try(example_fun(c(TRUE, FALSE, FALSE)))

try(example_fun(1:10))
}
\author{
Thomas Neitmann
}
\keyword{assertion}
