library("adjclust")

check_snp <- function() {
  if (!requireNamespace("snpStats")) {
    skip("'snpStats' package not available")
  }
}

context("Consistency of the results of 'snpClust' across various input formats")

# check function kept for possible future usage
check_snpStat_data <- function() {
  sf <- system.file("data/ld.example.RData", package="snpStats")
  expected <- "497fcd532b5c2bcb082a0dad7ca0d44d"
  if (!(tools::md5sum(sf) == expected)) {
      skip("Different version of data('ld.example', package = 'snpStats')")
  }
}

test_that("'snpClust' gives identical results regardless of data input format", {
  check_snp()
  
  check_snpStat_data()
  
  data("ld.example", package = "snpStats")
  h <- 100
  ld.ceph <- snpStats::ld(ceph.1mb, depth = h, stats = "R.squared")
  p <- ncol(ceph.1mb)
  nSamples <- nrow(ceph.1mb)
  h <- 100
  ceph.1mb[4,286]@.Data[1,1] <- as.raw(3) ## to avoid NaNs
  ld.ceph <- snpStats::ld(ceph.1mb, depth = h, stats = "R.squared")
  #ld.ceph <- round(ld.ceph, digits = 10)
    
  #case1: Input belongs to class Matrix::dgCMatrix generated by snpStats::ld function
  ## diagonal elements are 0
  expect_identical(diag(ld.ceph), rep(0, p))
  ld.ceph[ld.ceph > 1] <- 1
  expect_message(snpClust(ld.ceph, h = 100), 
                "Note: forcing the diagonal of the LD similarity matrix to be 1",
                all = FALSE)
  fit1 <- snpClust(ld.ceph, h = 100)

  # LD values less than 0 or larger than 1
  ld1 <- ld.ceph
  ld1[1,2] <- 1.1
  expect_warning(snpClust(ld1, h = 100))
  ld1[1,2] <- -0.1
  expect_warning(snpClust(ld1, h = 100))
  rm(ld1)
  
  #case2: Input belongs to class snpStats::SnpMatrix
  fit2 <- snpClust(ceph.1mb, h = 100, stats = "R.squared")  
  expect_equal(fit2$merge, fit1$merge)
  expect_equal(fit2$height, fit1$height)  
    
  #case3: Input belongs class base::matrix
  ceph.1mb <- as.matrix(ceph.1mb)
  fit3 <- snpClust(ceph.1mb, h = 100, stats = "R.squared")  
  expect_equal(fit3$merge, fit1$merge)
  expect_equal(fit3$height, fit1$height)
    
  #case4: default h
  ld.ceph.2 <- snpStats::ld(ceph.1mb, depth = ncol(ceph.1mb) - 1, stats = "R.squared")
  ld.ceph.2 <- round(ld.ceph.2, digits = 10)
  fit4 <- snpClust(ld.ceph.2, ncol(ceph.1mb) - 1)
  fit5 <- snpClust(ld.ceph.2)
  fit6 <- snpClust(ceph.1mb, stats = "R.squared")
  expect_equal(fit4$merge, fit5$merge)
  expect_equal(fit4$height, fit5$height)
  # expect_equal(fit4$merge, fit6$merge) ## identical heights but different merges
  expect_equal(fit4$height, fit6$height)
})
