% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/01genericSupport.r
\name{rawToAmigaDate}
\alias{rawToAmigaDate}
\title{Convert raw values into a date time object}
\usage{
rawToAmigaDate(x, format = c("long", "short"), tz = "UTC")
}
\arguments{
\item{x}{a \code{vector} of \code{raw} values with a length of a multitude
of 6 (for the short format) or 12 (for the long format).}

\item{format}{a \code{character} string indicating whether the date
is stored as \code{short} or \code{long} integers.}

\item{tz}{A \code{character} string specifying the time zone to be used
to retrieve the date time object. Note that the time zone is not stored
on the Amiga. By default the Universal time zone (UTC) is assumed.}
}
\value{
Returns a \code{\link[base]{POSIXct}} object based on the provided
raw data.
}
\description{
This function converts raw data into a date time object conform the
Amiga file system specifications.
}
\details{
The Amiga file system stores date time objects as three unsigned
short (16 bit) or long (32 bit) integers. Where the values are
number of days, minutes and ticks (fiftieth of a second) since
1978-01-01 respectively.

As these values are always positive, only date time values on or after
1978-01-01 are allowed. The inverse of this function can be achieved
with \code{\link{amigaDateToRaw}}.
}
\examples{
## all raw data is zero, so the origin date is returned:
rawToAmigaDate(raw(12))

## let's get the date, one day, one minute and 50 ticks from the origin:
rawToAmigaDate(amigaIntToRaw(c(1, 1, 50), 32))
}
\seealso{
Other raw.operations: \code{\link{amigaDateToRaw}},
  \code{\link{amigaIntToRaw}},
  \code{\link{displayRawData}}, \code{\link{rawToAmigaInt}}
}
\author{
Pepijn de Vries
}
