% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.R
\docType{methods}
\name{plot.adea}
\alias{plot.adea}
\alias{plot}
\alias{plot,adea-method}
\title{ADEA plot of standarized virtual input and virtual output}
\usage{
\method{plot}{adea}(
  x,
  main = NULL,
  xlab = NULL,
  ylab = NULL,
  labels = NULL,
  labels.pos = 4,
  lcol = "black",
  ...
)
}
\arguments{
\item{x}{ADEA object to be plotted}

\item{main}{if not null then it is used as main in plot.
Its default value is the translation of "ADEA efficient frontier".
If the adea x has name it is added to the previous value.}

\item{xlab}{if not null then it is used as xlab in plot.
Its default value is the translation of "Virtual input".}

\item{ylab}{if not null then it is used as ylab in plot.
Its default value is the translation of "Virtual output".}

\item{labels}{if not null then a vector of labels for the DMUs points}

\item{labels.pos}{position for the labels in the plot. Its default value is 4.}

\item{lcol}{the color to use to draw the line.
Its default value is black.}

\item{...}{Adittional parameters to plot}
}
\value{
A list with vinput and voutput values.
These values are provided mainly for use with the function identify.
}
\description{
ADEA plot of standarized virtual input and virtual output
}
\details{
This function plots virtual input and virtual outpus in an ADEA model.
The virtual input and output vectors are computed as a weighted sum of the inputs and outputs.
In addition, it is imposed that the sum of the weights be the unit.

For more information on this calculation process see the references in \cite{adea-package}.

For the calculations of virtual input and virtual output, the weights generated by ADEA have been used, but they are the same as those that would be obtained using standard DEA.
}
\examples{
data("cardealers4")
input = cardealers4[, c('Employees', 'Depreciation')]
output = cardealers4[, c('CarsSold', 'WorkOrders')]
adea <- adea(input = input, output = output)
plot(adea)
}
\seealso{
\code{\link{adea}}
}
\keyword{ADEA}
\keyword{DEA}
\keyword{plot}
