% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/do_kNNo.R
\name{do_knno}
\alias{do_knno}
\title{kNN for outlier detection}
\usage{
do_knno(data, k, top_n)
}
\arguments{
\item{data}{Data observations.}

\item{k}{Number of neighbors of a point that we are interested in.}

\item{top_n}{Total number of outliers we are interested in.}
}
\description{
Ramaswamy et al. proposed the k-nearest neighbors outlier detection method (kNNo). 
Each point's anomaly score is the distance to its kth nearest neighbor in the 
data set. Then, all points are ranked based on this distance. The higher an example's 
score is, the more anomalous it is.
}
\examples{
data(mtcars)
data <- as.matrix(mtcars)
do_knno(data, 3, 2)
                 
}
\references{
Ramaswamy, S., Rastogi, R. and Shim, K. 
Efficient Algorithms for Mining Outliers from Large Data Sets.
SIGMOD'00 Proceedings of the 2000 ACM SIGMOD international conference 
on Management of data, 2000, 427-438.
}
\author{
Guillermo Vinue
}
