% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/GCMMplots.R
\name{mixtureplot}
\alias{mixtureplot}
\title{GCMM Mixture Plot}
\usage{
mixtureplot(
  model,
  rug = FALSE,
  ruglwd = 2,
  lwd = 3,
  scale = "NULL",
  ymax = "NULL",
  col = "black",
  lty = 1,
  axisunits = c("radians", "time", "sun", "solar", "none"),
  xlines = TRUE
)
}
\arguments{
\item{model}{Model output from \code{\link{GCMM}} function, object of class \code{GCMM}}

\item{rug}{Logical argument for whether to plot a rug of the raw values. Plotting the rug for the separate components requires that saveclustIDs=TRUE when running \code{\link{GCMM}} or \code{\link{updateGCMM}}. default=FALSE}

\item{ruglwd}{Line width for rug plot}

\item{lwd}{Line width for activity curve}

\item{scale}{Scale for the plot, either "pi" (-pi, pi) or "2pi" (0, 2pi); default is that recommended by the \code{\link{GCMM}} function}

\item{ymax}{Value to use as y-axis maximum}

\item{col}{Line colour for plot}

\item{lty}{Line type for activity curve}

\item{axisunits}{Scale to use for the xaxis, either "radians", "time", "solar", "sun", or "none"; default="radians"}

\item{xlines}{Whether to include lines on the graph for the x axis labels; default=TRUE}
}
\value{
Prints mixture plot of the estimated activity curve from the circular mixture model
}
\description{
Plot of estimated activity curve from the circular mixture model
}
\examples{
\donttest{ FoxActivityGCMM<-GCMM(data=redfoxsample$Radians, 
              RE1=redfoxsample$SamplingPeriod, family="vonmises", autorun=FALSE,
              adapt=0, sample=300, burnin=300, thin=1, n.chains=2)
           mixtureplot(FoxActivityGCMM) }
 
}
