% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/act_tbl.R
\name{summary.act_tbl}
\alias{summary.act_tbl}
\title{Summarizes \code{\link[=act_tbl-class]{act_tbl}} objects.}
\usage{
\method{summary}{act_tbl}(object, full = FALSE, units = c("imperial", "metric"), ...)
}
\arguments{
\item{object}{an object for which a summary is desired}

\item{full}{Whether every column should be included, and filled with NA if
missing. Most useful to ensure the tibble has the same shape for
every file, allowing eventual use of \code{dplyr::bind_rows()} or
\code{purrr::map_dfr()} to create a full summary data set.}

\item{units}{Which units should be used?
\itemize{
\item "imperial" returns distance in miles, pace in minutes per mile, and
elevation in feet.
\item "metric" returns distance in kilometers, pace in minutes per kilometer, and
elevation in meters.
}}

\item{...}{Additional arguments.}
}
\value{
Returns a tibble with a single row, containing a summary of the given
\code{\link[=act_tbl-class]{act_tbl}}.
}
\description{
\code{summary.act_tbl} returns a tibble with canonical information about
the activity.
}
\details{
This is designed to allow for easy creation of activity summary data
sets by mapping summary over each \code{\link[=act_tbl-class]{act_tbl}} then using
\code{dplyr::bind_rows()}, \code{purrr::map_dfr()}, or equivalent to create a complete
data set.
}
\examples{
example_gpx_file <- system.file(
  "extdata",
  "running_example.gpx.gz",
  package = "activatr"
)
act_tbl <- parse_gpx(example_gpx_file)
summary(act_tbl)

\dontrun{
files <- list.files("path/to/many/files", pattern = "*.gpx")
gpxs <- files |> purrr::map(\(f) parse_gpx(f))
summaries <- gpxs |> purrr::map_dfr(\(g) summary(g, full = TRUE))
}

}
