% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/print.R
\name{roseMean}
\alias{roseMean}
\title{Draw mean value in the axis margin}
\usage{
roseMean(
  input,
  col = c("cornflowerblue", "chartreuse3", "deeppink"),
  mean.length = c(0.0125, -0.0125),
  mean.lwd = 4,
  box.range = c("none", "std.error", "sd"),
  fill = "white",
  horizontal.border = "black",
  vertical.border = "black",
  box.size = c(1.015, 0.985),
  edge.length = c(0.025, -0.025),
  edge.lwd = 2
)
}
\arguments{
\item{input}{the input dataset}

\item{col}{The colours to be used when drawing the means.}

\item{mean.length}{vertical length of the mean dash.}

\item{mean.lwd}{width of the mean dash.}

\item{box.range}{One of "none", "std.error" or "sd", controls the statistic used to draw the range boxes.}

\item{fill}{Fill colour for the range box.}

\item{horizontal.border}{Border colour for the horizontal edges of the range box.}

\item{vertical.border}{Border colour for the vertical edges of the range box.}

\item{box.size}{Vertical size of the range box.}

\item{edge.length}{Vertical size of the edge whiskers in the range box.}

\item{edge.lwd}{Width of the edge whiskers in the range box.}
}
\value{
No return value, adds to an existing plot.
}
\description{
Computes and draws the mean value for a given dataset, may also plot standard error of the mean
or standard deviation ranges.
}
\keyword{internal}
