% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/search_run.R
\name{search_run}
\alias{search_run}
\title{Run a search}
\usage{
search_run(x, s, showProgress = TRUE, updateX = TRUE)
}
\arguments{
\item{x}{Corpus object.}

\item{s}{Search object.}

\item{showProgress}{Logical; if \code{TRUE} progress bar will be shown.}

\item{updateX}{Logical; If \code{TRUE} the original corpus object passed as x to the function will also be updated, in case that fulltexts are created or the normalization is performed. If you do not want this, set to \code{FALSE}.}
}
\value{
Search object.
}
\description{
Runs a search, based on an existing search object s, in a corpus object x.
}
\examples{
library(act)

# Search for the 1. Person Singular Pronoun in Spanish.
# Only create the search object without running the search.
mysearch <- act::search_new(x=examplecorpus, pattern= "yo", runSearch=FALSE)

# Run the search
mysearch <- act::search_run(x=examplecorpus, s=mysearch)
mysearch
mysearch@results$hit
}
