% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gravity_model.R
\name{gravity_access}
\alias{gravity_access}
\title{Gravity-based accessibility measures}
\usage{
gravity_access(
  data,
  opportunity_col,
  decay_function,
  travel_cost_col = "travel_time",
  by_col
)
}
\arguments{
\item{data}{A \code{data.frame} with a travel cost matrix in long format,
containing the columns with origin ids, destination ids, the travel cost
between each origin-destination pair (this can be either in  terms of
travel time, distance or monetary costs), and number of population and
opportunities located in each origin and destination.}

\item{opportunity_col}{A \code{string} indicating the name of the column with the
number of opportunities / resources / services to be considered.}

\item{decay_function}{A \code{fuction} that converts travel cost (t_ij) into an
impedance factor used to weight opportunities. For convenience, the package
currently includes the following functions: \code{decay_bineary},
\code{decay_exponential}, \code{decay_exponential} and \code{decay_power}.
See the documentation of each decay function for more details.}

\item{travel_cost_col}{A \code{string} with the name of the column with travel
cost between origins and destinations. It can be either either travel time,
distance or monetary costs. Defaults to \code{travel_ime}.}

\item{by_col}{A \code{string} with the name of the column of origin or
destination that should be considered, indicating whether accessibility
levels should by calculated by each origin (active accessibility) or
destination (passive accessibility).}
}
\value{
A \code{data.table} object.
}
\description{
The function calculates gravity-based accessibility measures. Accessibility
can be calculated using multiple alternative decay functions passed through
the \code{decay_function} parameter.
}
\examples{
library(accessibility)

# load a travel time matrix data in long format
data_path <- system.file("extdata/ttm_bho.rds", package = "accessibility")
ttm <- readRDS(data_path)

df_linear <- gravity_access(data = ttm,
                           opportunity_col = 'schools',
                           decay_function = decay_linear(cutoff = 50),
                           travel_cost_col = 'travel_time',
                           by_col = 'from_id'
                           )

head(df_linear)

df_exp <- gravity_access(data = ttm,
                        opportunity_col = 'schools',
                        decay_function = decay_exponential(decay_value = 0.5),
                        travel_cost_col = 'travel_time',
                        by_col = 'from_id'
                        )
head(df_exp)

}
\concept{Gravity-based accessibility}
