% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/decay_linear.R
\name{decay_linear}
\alias{decay_linear}
\title{Linear decay function}
\usage{
decay_linear(cutoff)
}
\arguments{
\item{cutoff}{A \code{numeric} value. A number indicating the max cutoff point of
travel cost.}
}
\value{
A \code{function} that converts travel time cost t_id into an impedance factor.
}
\description{
Returns a linear impedance function to be used inside \code{accessibility}
functions.
}
\examples{
library(accessibility)

# Create a linear impedance function
impedance <- decay_linear(cutoff = 30)

impedance(t_ij = 20)
impedance(t_ij = 25)
impedance(t_ij = 35)

}
\seealso{
Other Impedance functions: 
\code{\link{decay_binary}()},
\code{\link{decay_exponential}()},
\code{\link{decay_power}()}
}
\concept{Impedance functions}
