% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/test_fun.R
\name{test_fun}
\alias{test_fun}
\title{Tests a function by checking if its arguments are declared}
\usage{
test_fun(f, force_default = FALSE)
}
\arguments{
\item{f}{A function}

\item{force_default}{Whether or not to assign the default value to arguments
that already have assigned values}
}
\description{
This function verifies whether all of the arguments of another
function already have assigned values. If an argument has a default value
but there isn't a corresponding variable, it creates that variable.
}
\examples{
\dontrun{
f <- function(a, b = 3) {
  a * b
}

test_fun(f)
a
b

b <- 5
test_fun(f)
a
b

test_fun(f, TRUE)
a
b

a <- 2
test_fun(f)
a
b
}

}
