% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/abe.R
\name{abe.num}
\alias{abe.num}
\title{ABE for models which include only numeric covariates}
\usage{
abe.num(fit, data, include = NULL, active = NULL, tau = 0.05,
  exp.beta = TRUE, exact = FALSE, criterion = "alpha", alpha = 0.2,
  type.test = "Chisq", verbose = T)
}
\description{
ABE for models which include only numeric covariates
}
\examples{
\dontshow{
set.seed(1)
n=100
x1<-runif(n)
x2<-runif(n)
x3<-runif(n)
y<--5+5*x1+5*x2+ rnorm(n,sd=5)
dd<-data.frame(y,x1,x2,x3)
fit<-lm(y~x1+x2+x3,x=TRUE,y=TRUE,data=dd)

abe.fit<-abe.num(fit,data=dd,include="x1",active="x2",
tau=0.05,exp.beta=FALSE,exact=TRUE,criterion="alpha",alpha=0.2,
type.test="Chisq",verbose=FALSE)
summary(abe.fit)
}
}
\keyword{internal}
