% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/stat_glm.R
\name{stat_glm}
\alias{stat_glm}
\title{Create a glm stat object.}
\usage{
stat_glm(std.beta = FALSE, complete.cases = TRUE)
}
\arguments{
\item{std.beta}{logical. Whether to standardize model predictors and
covariates prior to analysis.}

\item{complete.cases}{logical. Whether to only include the subset of data
with no missing data for any of the outcomes, predictors, or covariates.
Note that complete cases are considering within each group - outcome
combination but across all predictor sets.}
}
\value{
An abaStat object with \code{glm} stat type.
}
\description{
This function creates a glm stat object which can be passed as input
to the \code{set_stats()} function when building an aba model. This stat performs
a traditional logistic regression analysis using the \code{glm} function with
a binary outcome. Coefficients will be presented as odds ratios. Default
metrics include AUC.
}
\examples{

data <- adnimerge \%>\% dplyr::filter(VISCODE == 'bl')

# fit glm model with binary outcome variables
model <- data \%>\% aba_model() \%>\%
  set_groups(everyone()) \%>\%
  set_outcomes(ConvertedToAlzheimers, CSF_ABETA_STATUS_bl) \%>\%
  set_predictors(
    PLASMA_PTAU181_bl, PLASMA_NFL_bl,
    c(PLASMA_PTAU181_bl, PLASMA_NFL_bl)
  ) \%>\%
  set_stats(
    stat_glm(std.beta = TRUE)
  ) \%>\%
  fit()

# summarise glm model
model_summary <- model \%>\% summary()

# plot glm results
fig1 <- model_summary \%>\% aba_plot_coef()
fig2 <- model_summary \%>\% aba_plot_metric()
fig3 <- model_summary \%>\% aba_plot_roc()

}
