% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/aba_control.R
\name{aba_control}
\alias{aba_control}
\title{Create an aba control object.}
\usage{
aba_control(
  include_intercept = FALSE,
  include_covariates = TRUE,
  pval_digits = 4,
  aic_digits = 0,
  metric_digits = 2,
  coef_digits = 2
)
}
\arguments{
\item{include_intercept}{boolean. Whether to include intercept in coefs}

\item{include_covariates}{boolean. Whether to include covariates in coefs}

\item{pval_digits}{integer. How many decimals of a pvalue to show}

\item{aic_digits}{integer. How many decimals of AIC value to show}

\item{metric_digits}{integer. Default value of how many decimals to show
for model metrics (e.g., auc, adj.r.squared, etc)}

\item{coef_digits}{integer. Default value of how many decimals to show
for model coefficients}
}
\value{
a list with the control parameters specified
}
\description{
The aba control which determines how an aba summary will be calculated and
printed to console.
}
\examples{

df <- adnimerge \%>\% dplyr::filter(VISCODE == 'bl')

# standard example
model <- df \%>\% aba_model() \%>\%
  set_groups(everyone()) \%>\%
  set_outcomes(CSF_ABETA_STATUS_bl) \%>\%
  set_predictors(
    PLASMA_PTAU181_bl, PLASMA_NFL_bl,
    c(PLASMA_PTAU181_bl, PLASMA_NFL_bl)
  ) \%>\%
  set_covariates(AGE, GENDER, EDUCATION) \%>\%
  set_stats('glm') \%>\%
  aba_fit()

# no control -> default
model_summary <- model \%>\% aba_summary()
print(model_summary)

# add a control object - don't include covariate coefficients
my_control <- aba_control(include_covariates = FALSE)
model_summary2 <- model \%>\% aba_summary(control = my_control)
print(model_summary2)

}
