% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/canvas_smoke.R
\name{canvas_smoke}
\alias{canvas_smoke}
\title{Draw Rainbow Smoke}
\usage{
canvas_smoke(colors, init = 1, shape = c("bursts", "clouds"),
             algorithm = c("minimum", "average"), resolution = 150)
}
\arguments{
\item{colors}{a string or character vector specifying the color(s) used for the artwork.}

\item{init}{an integer larger than zero and lower  than or equal to \code{resolution^2} specifying the initial number of pixels to color on the canvas.}

\item{shape}{a character indicating the shape of the smoke. Possible options are \code{burst} and \code{clouds}.}

\item{algorithm}{a character specifying how to select a new pixel. The default option \code{minimum} selects the pixel with the smallest color difference in a single neighbor and is relatively fast. The option \code{average} selects the pixel with the smallest average color difference in all the neighbors and is relatively slow.}

\item{resolution}{resolution of the artwork in pixels per row/column. Increasing the resolution increases the quality of the artwork but also increases the computation time exponentially.}
}
\value{
A \code{ggplot} object containing the artwork.
}
\description{
This function implements the rainbow smoke algorithm.
}
\examples{
\donttest{
set.seed(1)

# Simple example
canvas_smoke(colors = "all", resolution = 500)

# Advanced example
reds <- colorRampPalette(c("red", "black"))
blues <- colorRampPalette(c("goldenrod", "navyblue"))
palette <- c(reds(100), blues(100))
canvas_smoke(colors = palette, init = 3, shape = "clouds", resolution = 500)
}

}
\references{
\url{http://rainbowsmoke.hu}
}
\seealso{
\code{colorPalette}
}
\author{
Koen Derks, \email{koen-derks@hotmail.com}
}
\keyword{artwork}
\keyword{canvas}
