% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Catalan.R
\name{Catalan}
\alias{Catalan}
\alias{A000108}
\alias{Segner}
\title{Catalan numbers}
\usage{
Catalan(n, Rmpfr = TRUE, PrecisionBits = 496)
}
\arguments{
\item{n}{the number of first \code{n} entries from the sequence.}

\item{Rmpfr}{a logical; \code{TRUE} to use large number representation, \code{FALSE} otherwise.}

\item{PrecisionBits}{a positive integer for precision bits larger than 2.}
}
\value{
a vector of length \code{n} containing first entries from the sequence.
}
\description{
Under OEIS \href{https://oeis.org/A000108}{A000108}, the \emph{n}th \emph{Catalan} number is given as
\deqn{C_n = \frac{(2n)!}{(n+1)!n!}}
where the first 6 entries are 1, 1, 2, 5, 14, 42 with \eqn{n\ge 0.}
}
\examples{
## generate first 30 Catalan numbers
first30 = Catalan(30)

## print without trailing 0's.
print(first30, drop0trailing = TRUE)

}
