% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotZLA.R
\name{plotZLA}
\alias{plotZLA}
\title{Web plots to illustrate Zipf's law of abbreviation}
\usage{
plotZLA(inputObject)
}
\arguments{
\item{inputObject}{output from the function testZLA}
}
\value{
Produces a webplot illustrating concordance between note duration and frequency of use within individuals. Requires output from the testZLA function.
}
\description{
Produces a webplot. It requires data calculated from the testZLA function.
}
\details{
In the figure produced by plotZLA, each point represents a note or phrase type in the population repertoire. Note types are joined by a line if both note types are produced by the same individual. The weight of the line is proportional to the number of individuals that produce both note types. The color of the lines indicates whether there is a positive (blue) or negative (red) concordance between the duration and frequency of use of the note types. Negative concordances are consistent with Zipf's law of abbreviation. Shades between blue and red indicate that the concordance is positive in some individuals and negative in others. For example, this can happen if some individuals use the note types more frequently than others, such that the rank order of frequency of use varies among individuals. Grey crosses centered on each point show the longest and shortest durations of the note type (vertical) and the highest and lowest frequencies of use (horizontal) in the population.
}
\references{
Davis, M. K. and Chen, G. (2007) Graphic Kendall's tau. Computational Statistics & Data Analysis, 51(5), 2373-2378. doi: 10.2307/2346786
}
\author{
CD Durrant and R. Tucker Gilman (2023)
}
