% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AnimateZEP.R
\name{AnimateZEP}
\alias{AnimateZEP}
\title{Function for animation of the whole list of fuzzy numbers}
\usage{
AnimateZEP(
  listOfValues,
  FUN,
  knots = 10,
  grid = TRUE,
  approximation = FALSE,
  method = "NearestEuclidean",
  sleep = 1,
  ...
)
}
\arguments{
\item{listOfValues}{List of the input fuzzy numbers.}

\item{FUN}{Function used for the input fuzzy number with the help of the Zadeh's principle.}

\item{knots}{Number of the alpha-cuts used during calculation of the output.}

\item{grid}{If \code{TRUE}, then additional grid is plotted.}

\item{approximation}{If \code{TRUE}, the approximated output is calculated.}

\item{method}{The selected approximation method.}

\item{sleep}{Interval between frames in the animation.}

\item{...}{Additional parameters passed to other functions.}
}
\value{
The figures are animated: the series of the input and output fuzzy numbers (for the Zadeh's principle
and the applied function) or their approximation (if selected).
}
\description{
\code{AnimateZEP} animates the whole list consisting of fuzzy numbers.
}
\details{
The function takes the list of input fuzzy numbers \code{listOfValues} (which should be described by one of the
classes from \code{FuzzyNumbers} package) and applies the function \code{FUN} using
the Zadeh's principle. The output is given as animation of consecutive fuzzy numbers or their approximations (when
\code{approximation} is set to \code{TRUE} and the respective \code{method} is selected).
To properly find the output, value of \code{FUN} is calculated for many alpha-cuts of \code{listOfValues}.
The number of these alpha-cuts is equal to \code{knots} (plus 2 for the support and the core).
If the approximation is used, then the approximated fuzzy number is shown with green line.

The input fuzzy number from a list \code{listOfValues} should be given by fuzzy number described by classes from \code{FuzzyNumbers} package.
}
\examples{

library(FuzzyNumbers)

# prepare list of fuzzy numbers

a <- seq(0,5,by=1)

fuzzyList <- list()

for (i in 1:length(a)) {
 
 fuzzyList[[i]] <- TrapezoidalFuzzyNumber(i,i+1,2*i+1,3*i+1)
 
}

# check the list
fuzzyList

# now some animations for various functions and then with approximation
AnimateZEP(fuzzyList,FUN=function(x) x^2)

AnimateZEP(fuzzyList,FUN=function(x) sin(x))

AnimateZEP(fuzzyList,FUN=function(x) x^3+1,approximation = TRUE)




}
