% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/youtube_oauth.R
\name{youtube_oauth}
\alias{youtube_oauth}
\title{YouTube API OAuth}
\usage{
youtube_oauth(
  clientId = NULL,
  clientSecret = NULL,
  tokenFile = ".httr-oauth",
  useOOB = FALSE,
  setEnvVar = FALSE
)
}
\arguments{
\item{clientId}{Required. Client Id obtained from console.cloud.google.com.}

\item{clientSecret}{Required. Client Secret obtained from console.cloud.google.com}

\item{tokenFile}{The name of the token httr-oauth file to read the token from. If the file does not exist then one will be created with the provided name.}

\item{useOOB}{If \code{TRUE}, use oob method to copy/paste token into R.}

\item{setEnvVar}{If \code{TRUE}, create an environment variable called "YouTube_Token" to store token.}
}
\value{
token environment
}
\description{
This creates or grabs a token to authorize API requests
}
\examples{
\dontrun{
youtube_oauth("123456789asdalksdjfhaslkdjfb.apps.googleusercontent.com",
              "MasdfH5320208ladshf790",
              token = ".httr-oauth-myToken")
}
}
