% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/survival_yppe.R
\name{survfit.yppe}
\alias{survfit.yppe}
\title{Survival function for the YPPE model}
\usage{
\method{survfit}{yppe}(object, newdata, ...)
}
\arguments{
\item{object}{an object of the class yppe}

\item{newdata}{a data frame containing the set of explanatory variables.}

\item{...}{further arguments passed to or from other methods.}
}
\value{
a list containing the estimated survival probabilities.
}
\description{
Survival function for the YPPE model
}
\examples{
\donttest{
# ML approach:
library(YPPE)
mle <- yppe(Surv(time, status)~arm, data=ipass, approach="mle")
summary(mle)
ekm <- survfit(Surv(time, status)~arm, data=ipass)
newdata <- data.frame(arm=0:1)
St <- survfit(mle, newdata)
time <- sort(ipass$time)
plot(ekm, col=1:2)
lines(time, St[[1]])
lines(time, St[[2]], col=2)

# Bayesian approach:
bayes <- yppe(Surv(time, status)~arm, data=ipass, approach="bayes")
summary(bayes)
ekm <- survfit(Surv(time, status)~arm, data=ipass)
newdata <- data.frame(arm=0:1)
St <- survfit(bayes, newdata)
time <- sort(ipass$time)
plot(ekm, col=1:2)
lines(time, St[[1]])
lines(time, St[[2]], col=2)
}

}
